% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{plot_centrality}
\alias{plot_centrality}
\title{Plot Centrality Measures}
\usage{
plot_centrality(obj, plot_type = "tiefighter", cis = 0.95)
}
\arguments{
\item{obj}{An object containing the centrality measures obtained from
\code{\link{get_centrality}}.}

\item{plot_type}{A character string specifying the type of plot. Accepts
"tiefighter" or "density". Default is \code{"tiefighter"}.}

\item{cis}{A numeric value specifying the credible interval. Must be between
0 and 1 (exclusive). Default is \code{0.95}.}
}
\value{
A ggplot object visualizing the centrality measures. For a
  "tiefighter" plot, each point represents the mean centrality measure for a
  variable, and the bars represent the credible interval. In a "density"
  plot, distribution of the centrality measures is visualized.
}
\description{
This function creates a plot of various centrality measures for a given
object. The plot can be either a "tiefighter" plot or a "density" plot. The
"tiefighter" plot shows the centrality measures for each variable with
uncertainty bands, while the "density" plot shows the full density of the
centrality measures.
}
\examples{
\donttest{
data(fit_data)
obj <- get_centrality(fit_data[[1]])
  plot_centrality(obj,
  plot_type = "tiefighter",
  cis = 0.95)
}

}
