% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_daily_hs.R
\name{sim_daily_hs}
\alias{sim_daily_hs}
\title{Simulate a daily time series based on the HS model}
\usage{
sim_daily_hs(
  N,
  multiplicative = TRUE,
  sizeWeeklySeas = 100,
  sizeAnnualSeas = 100,
  sizeTrend = 100,
  sizeDrift = 100,
  varIrregularity = 100,
  sizeWeeklySeasAux = 100,
  sizeAnnualSeasAux = 100,
  start = 2020,
  sizeBurnIn = 730,
  shockLevel = 1,
  shockDrift = 1,
  shockWeeklySeas = 1,
  shockAnnualSeas = 1,
  index = 100
)
}
\arguments{
\item{N}{Length of the simulated time series in years.}

\item{multiplicative}{If TRUE, a multiplicative model is simulated, an additive model if FALSE.}

\item{sizeWeeklySeas}{Size and stability of the weekly seasonal factor.}

\item{sizeAnnualSeas}{Size and stability of the annual seasonal factor.}

\item{sizeTrend}{Size of the trend component.}

\item{sizeDrift}{Size of the drift of the trend component.}

\item{varIrregularity}{Variance of the random irregular component.}

\item{sizeWeeklySeasAux}{Size of the auxiliary variable for the weekly seasonal factor.}

\item{sizeAnnualSeasAux}{size of the auxiliary variable for the annual seasonal factor.}

\item{start}{The initial date or year.}

\item{sizeBurnIn}{Size of burn-in sample in days.}

\item{shockLevel}{Variance of the shock to the level (trend).}

\item{shockDrift}{Variance of the shock to the drift (trend).}

\item{shockWeeklySeas}{Variance of the shock to the weekly seasonal.}

\item{shockAnnualSeas}{Variance of the shock to the annual seasonal.}

\item{index}{A value to which the mean of the base year (first effective year) of the time series is normalized.}
}
\value{
Multiple simulated daily time series of class xts including:
\describe{
\item{original}{The original series}
\item{seas_adj}{The original series seasonal effects}
\item{sfac7}{The day-of-the-week effect}
\item{sfac365}{The day-of-the-year effect}
}
}
\description{
This function simulates a daily time series with a Monte Carlo simulation based
on an STS model based on Harvey and Shephard (1993) (HS model).
The daily data consists of a trend, weekly seasonal, annual seasonal and
irregular component. The components are each simulated by a transition process
with daily random shocks. At the end of the simulation the components are combined and
normalized to form the complete time series.
}
\details{
The size of the components and the variance of the irregular component are defaulted to 100 each
and the variances of the shocks are defaulted to 1.

The first effective year serves as base year for the time series

The impact of a seasonal factor on the time series depends on its ratio to
the other components. To increase (decrease) a factor's impact, the value of
the size needs to be increased (decreased) while the other components need to be
kept constant. Therefore, the stability of the seasonal factor also grows as
the shocks on the given component have less impact.
In order to increase the impact without increasing the stability, the variance
of the shock also needs to be raised accordingly.
}
\examples{
x <- sim_daily_hs(4)
ts.plot(x[,1])
}
\references{
Cuevas, Ángel and Quilis, Enrique M., Seasonal Adjustment Methods for Daily Time Series. A Comparison by a Monte Carlo Experiment (December 20, 2023). Available at SSRN: https://ssrn.com/abstract=4670922 or http://dx.doi.org/10.2139/ssrn.4670922

Structural Time Series (STS) Monte Carlo simulation Z = trend + seasonal_weekly + seasonal_annual + irregular, according to Harvey and Shephard (1993): "Structural Time Series Models", in Maddala, G.S., Rao, C.R. and Vinod, H.D. (Eds.) Handbook of Statistics, vol. 11, Elsevier Science Publishers.
}
\author{
Nikolas Fritz , Daniel Ollech, based on code provided by Ángel Cuevas and Enrique M Quilis
}
