% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDF.R
\name{EDF}
\alias{EDF}
\title{Compute the effective degrees freedom in a tvcure model}
\usage{
EDF(model, Wood.test = FALSE, joint.computation = TRUE)
}
\arguments{
\item{model}{A tvcure object}

\item{Wood.test}{Logical indicating if P-values based on Wood's test (Biometrika 2013) of the significance of additive terms should be preferred over basic Chi-square tests. (Default: FALSE).}

\item{joint.computation}{Logical indicating if variance-covariance matrices for the regression and spline parameters in the long- and short-term survival submodels should be computed jointly (TRUE) or separately (FALSE). (Default: TRUE).}
}
\value{
A list containing the effective degrees of freedom for the additive terms in the long-term (quantum) and short-term (timing) survival submodels, with the selected statistical test for significance and its P-value.
}
\description{
Compute the effective degrees freedom in a tvcure model
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
EDF(model)
}
}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
