% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculated_fields.R
\name{extract_parameters}
\alias{extract_parameters}
\title{Extract parameter fields from a TWB}
\usage{
extract_parameters(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\describe{
\item{datasource}{Datasource name.}
\item{name}{User-visible caption or cleaned internal name.}
\item{tableau_internal_name}{Internal Tableau name.}
\item{datatype}{Tableau datatype.}
\item{role}{Tableau role.}
\item{parameter_type}{Tableau parameter domain type.}
\item{allowable_type}{Underlying data-type (if present).}
\item{current_value}{Current value if specified.}
\item{is_parameter}{Always \code{TRUE}.}
\item{table}{Raw table reference.}
\item{table_clean}{Cleaned table name.}
}
}
\description{
Returns parameter columns (those with \code{param-domain-type}) and basic metadata,
including a best-effort current value if present.
}
\examples{
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
params <- extract_parameters(xml)
head(params)


}
