% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_twig_obj.R
\name{payoffs}
\alias{payoffs}
\title{Add payoffs to a twig object}
\usage{
payoffs(names, discount_rates = NULL)
}
\arguments{
\item{names}{A character vector of payoff function names.  They don't need to be included in quotes.}

\item{discount_rates}{A numeric vector of discount rates for each payoff. If NULL, a discount rate of 0 is assumed for each payoff.
discount_rates must have the same length as payoff names.}
}
\value{
A list representing the payoffs layer.
}
\description{
This function creates a payoffs layer that can be added to a twig object. The payoffs layer defines the payoffs and their associated discount rates.
}
\examples{
payoffs_layer <- payoffs(names = c(cost, effectiveness), discount_rates = c(0.03, 0.03))

}
