% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{typr_compile}
\alias{typr_compile}
\title{Compile a Typst document}
\usage{
typr_compile(
  input = NULL,
  output_file = NULL,
  output_format = c("pdf", "png", "svg", "html"),
  typst_args = NULL
)
}
\arguments{
\item{input}{either a path to a \code{.typ} file or text to use as the file}

\item{output_file}{file to output to}

\item{output_format}{format to use. One of \code{c('pdf', 'png', 'svg', 'html')},}

\item{typst_args}{Additional arguments to pass to Typst. Can be listed with \code{typr_help('compile')}}
}
\value{
a path to the created file
}
\description{
Compile a Typst document
}
\examples{
\dontshow{if (has_any_typst()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
typr_compile('hello world')
typr_compile(
  input = 'Hello world', output_format = 'png',
  typst_args = c('--ppi', '300')
)
\dontshow{\}) # examplesIf}
}
