% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data_DESN025.R
\docType{data}
\name{sample_data_DESN025}
\alias{sample_data_DESN025}
\title{Environmental Data for Modelling from station DESN025 in Leipzig-Mitte.}
\format{
\subsection{sample_data_DESN025}{

A data table with the following columns:
\describe{
\item{Station}{Station identifier where the data was collected.}
\item{Komponente}{The environmental component being measured
(e.g., temperature, NO2).}
\item{Wert}{The measured value of the component.}
\item{date}{The timestamp for the observation, formatted as a Date-Time
object in the format
\code{"YYYY-MM-DD HH:MM:SS"} (e.g., "2010-01-01 07:00:00").}
\item{Komponente_txt}{A textual description or label for the component.}
}

The dataset is structured in a long format and is prepared for further
transformation into a wide format for modelling.
}
}
\source{
Umweltbundesamt
}
\usage{
sample_data_DESN025
}
\description{
A dataset containing environmental measurements collected at station in
Leipzig Mitte with observations of different environmental components over
time. This data is used for environmental modelling tasks, including
meteorological variables and other targets.
}
\examples{
\donttest{
data(sample_data_DESN025)
params <- load_params()
dt_prepared <- prepare_data_for_modelling(sample_data_DESN025, params)
}
}
\keyword{datasets}
