% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_log_debug_save}
\alias{system_log_debug_save}
\title{Save variables to files}
\usage{
system_log_debug_save(cfg, file_name = "my_file", values = NULL)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{file_name}{name of the save file without the ".RData" extension}

\item{values}{named list of variables to save}
}
\value{
Boolean variable indicating success
}
\description{
Triggered when debugging is enabled, this function will save
the contents of values to the specified file name in the ubiquity temporary
directory.
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# enable debugging:
cfg=system_set_option(cfg,group = "logging", 
                         option = "debug", 
                         value  = TRUE)

# Saving the cfg variable 
system_log_debug_save(cfg, 
   file_name = 'my_file',
   values = list(cfg=cfg))

}
}
