% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unique_identifier}
\alias{unique_identifier}
\title{Create a unique identifier for each combination of fields in a data frame}
\usage{
unique_identifier(x, fields, start_from = 1L)
}
\arguments{
\item{x}{a data.frame}

\item{fields}{a character vector of columns from \code{x}}

\item{start_from}{integer number indicating to start from that number onwards}
}
\value{
an integer vector of the same length as the number of rows in \code{x} 
containing the unique identifier
}
\description{
Create a unique identifier for each combination of fields in a data frame. 
This unique identifier is unique for each combination of the elements of the fields. 
The generated identifier is like a primary key or a secondary key on a table.
This is just a small wrapper around \code{\link[data.table]{frank}}
}
\examples{
data(brussels_reviews_anno)
x <- brussels_reviews_anno
x$doc_sent_id <- unique_identifier(x, fields = c("doc_id", "sentence_id"))
head(x, 15)
range(x$doc_sent_id)
x$doc_sent_id <- unique_identifier(x, fields = c("doc_id", "sentence_id"), start_from = 10)
head(x, 15)
range(x$doc_sent_id)
}
