% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mf_data_demo}
\alias{mf_data_demo}
\title{mf_data_demo}
\format{
A data.table with ~9245 rows (formulas) and 65 variables:
\describe{
\item{file_id}{Unique ID (integer) for each analysis}
\item{peak_id}{Unique ID (integer) for each mass peak in the peak list 'pl'}
\item{mz}{Mass to charge ratio of the singly charged molecular ion (numeric)}
\item{i_magnitude}{Measured mass peak magnitude of the singly charged molecular ion (numeric)}
\item{norm_int}{Normalized intensity as calculated by calc_norm_int()}
\item{m}{Neutral measured mass of the molecular ion}
\item{m_cal}{Neutral calculated mass of the assigned formula}
\item{ppm}{Realtive mass accuracy of measured mass compared to m_cal (in ppm)}
\item{nm}{Nominal mass of the neutral molecule}
\item{mf}{molecular formula (no differentiation of isotopes)}
\item{dbe}{Double bond equivalent}
\item{\verb{12C}}{Number of carbon atoms (12C)}
\item{\verb{1H}}{Number of hydrogen atoms}
\item{hc}{hydrogen / carbon ratio in a molecular formula}
\item{oc}{oxygen / carbon ratio in a molecular formula}
\item{nc}{nitrogen / carbon ratio in a molecular formula}
\item{sc}{sulfur / carbon ratio in a molecular formula}
\item{ai}{Aromaticity index according to Koch and Dittmar (2008, 2016)}
\item{z}{z score according to Stenson et al. (2003)}
\item{kmd}{Kendrick mass defect (based on CH2-units) according to Kendrick (1963)}
\item{ppm_filt}{Calculated threshold value for relative mass accuracy (in ppm) that can be used for formular filtering}
\item{mf_id}{Identifier for each unique molecular formula identified in the unfiltered dataset}
\item{CRAM}{Molecular formula that was identified (CRAM == 1) as carboxylic rich alicyclic molecule according to Hertkorn et al. (2006). See ume::known_mf for details.}
\item{int13c}{Measured relative peak magnitude of the 13C1 isotope compared to the parent ion (0 if isotope was not existing)}
\item{int15n}{Measured relative peak magnitude of the 15N1 isotope compared to the parent ion (0 if isotope was not existing)}
\item{int34s}{Measured relative peak magnitude of the 34S1 isotope compared to the parent ion (0 if isotope was not existing)}
\item{dev_n_c}{Deviation of the 12C/13C isotope ratio represented in carbon numbers according to Koch et al. (2007)}
\item{dbe_o}{DBE minus O}
\item{nosc}{Nominal oxidation state of carbon according to LaRowe & Van Cappellen (2011)}
\item{delg0_cox}{Standard molal Gibbs energies of the oxidation half reactions of organic compounds according to LaRowe & Van Cappellen (2011)}
\item{co_tot}{Total number of carbon and oxygen atoms in a molecular formula}
\item{nsp_tot}{Total number of nitrogen, sulfur, and phosphorus atoms in a molecular formula}
\item{n_occurrence_orig}{Number of occurrences of a molecular formula in the entire unfiltered set of formulas}
\item{n_assignments_orig}{Number of molecular formula assignments per molecular mass in the unfiltered set of formulas}
\item{n_assignments}{Number of molecular formula assignments per molecular mass after filter process}
\item{int_bp}{Magnitude of the base peak in a mass spectrum}
\item{int_bp}{Total magnitude of the reference that was used for normalization (cf. calc_norm_int())}
}
}
\source{
{taken from www.awi.de}
}
\usage{
mf_data_demo
}
\description{
Contains molecular formula data and metainformation on formulas.
The metainformation
}
\examples{
data(mf_data_demo)
}
\seealso{
Other ume data: 
\code{\link{known_mf}},
\code{\link{lib_demo}},
\code{\link{masses}},
\code{\link{nice_labels_dt}},
\code{\link{peaklist_demo}},
\code{\link{tab_ume_labels}}
}
\concept{ume data}
\keyword{datasets}
