% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financial_functions.R
\name{fin_net_present_value}
\alias{fin_net_present_value}
\title{Compute the net present value of a future income stream}
\usage{
fin_net_present_value(
  income = 27000,
  discount_rate = 0.05,
  periods = 25,
  symbol = umx_set_dollar_symbol(silent = TRUE)
)
}
\arguments{
\item{income}{Value of expected recurring payment}

\item{discount_rate}{Percent return to discount against (.05 = 5\%)}

\item{periods}{How many periods the stream delivers, e.g., 25 years of pension.}

\item{symbol}{Currency symbol to use}
}
\value{
\itemize{
\item value
}
}
\description{
\code{fin_valuation} uses the revenue, operating margin, expenses and PE to compute a market capitalization.
Better to use a more powerful online site.
}
\details{
Revenue stream is discounted back to a present day cash amount which is equivalent.
}
\examples{
fin_net_present_value(27e3, .05, 25)

}
\seealso{
\itemize{
\item \code{\link[=fin_interest]{fin_interest()}}, \code{\link[=fin_NI]{fin_NI()}}, \code{\link[=fin_percent]{fin_percent()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_JustifiedPE}()},
\code{\link{fin_NI}()},
\code{\link{fin_expected}()},
\code{\link{fin_interest}()},
\code{\link{fin_percent}()},
\code{\link{fin_ticker}()},
\code{\link{fin_valuation}()},
\code{\link{rad2deg}()},
\code{\link{umxBrownie}()}
}
\concept{Miscellaneous Functions}
