% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin_rules.R
\name{rubin_b_and_ses}
\alias{rubin_b_and_ses}
\title{Pool coefficients and standard errors from multiple `coeftest` objects}
\usage{
rubin_b_and_ses(coeftests)
}
\arguments{
\item{coeftests}{A list of objects returned by `lmtest::coeftest()`. Each
element must have matching coefficient rows/columns, where column 1 is the
estimate and column 2 is the standard error.}
}
\value{
A `coeftest`-like numeric matrix with pooled estimates (col 1), pooled
  standard errors (col 2), pooled t-statistics (col 3), and two-sided p-values
  (col 4). Row/column names and attributes are inherited from the first
  element of `coeftests`.
}
\description{
Internal helper that takes a list of `lmtest::coeftest()` matrices and returns
a pooled `coeftest`-like matrix using Rubin's rules.
}
