% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSD.R
\docType{data}
\name{ucsd_1}
\alias{ucsd_1}
\title{Core colors of the University of California San Diego (UCSD), USA}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on \href{https://www.UCSD.edu}{UCSD}'s 
\href{https://brand.ucsd.edu/visual-brand/color/index.html}{Color manual}.
}
\usage{
ucsd_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ucsd_1} provides four Core colors.
of the \href{https://www.UCSD.edu}{UCSD, UC San Diego, University of California}, USA.
}
\details{
The 4 core colors are
\code{"UCSD navy"} (defined as CMYK 100/86/42/42, RGB R24/43/73, HEX #182B49),
\code{"UCSD blue"} (defined as CMYK 100/35/3/21, RGB R0/98/155, HEX #00629B),
\code{"UCSD yellow"} (defined as CMYK 0/14/100/0, RGB R255/205/0, HEX #FFCD00), and
\code{"UCSD gold"} (defined as CMYK 6/35/99/18, RGB R198/146/20, HEX #C69214).

\code{ucsd_1} uses the HEX color definitions.


\href{https://www.UCSD.edu}{UCSD}'s core colors are the official colors of UC San Diego. 
Consistent use of these colors in all branding is essential to establishing our identity.
}
\examples{
ucsd_1
unikn::seecol(ucsd_1, main = "The core colors of UCSD")  # view color palette

}
\seealso{
\code{\link{ucsd_2}} for accent colors of UC San Diego;
\code{\link{ucsd_3}} for neutral colors of UC San Diego;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{U.S. university color palettes}
\keyword{datasets}
