% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Konstanz.R
\docType{data}
\name{uni_konstanz_2}
\alias{uni_konstanz_2}
\title{Preferred colors of the University of Konstanz, Germany}
\format{
An object of class \code{character} of length 9.
}
\source{
R package \strong{unikn}, 
retrieved from \url{https://CRAN.R-project.org/package=unikn},    
doi \doi{10.5281/zenodo.7096191}. 

Original color definitions are based on \href{https://www.uni-konstanz.de}{uni.kn}'s 
\href{https://www.uni-konstanz.de/universitaet/aktuelles-und-medien/online-und-print-medien-gestalten/corporate-design/}{Corporate design} and   
\href{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/colours-for-complex-graphics/}{Colours for complex graphics} pages.
}
\usage{
uni_konstanz_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_konstanz_2} provides the palette of preferred colors  
of the \href{https://www.uni-konstanz.de}{University of Konstanz}, Germany.
}
\details{
The R package \strong{unikn} (at \url{https://CRAN.R-project.org/package=unikn}) 
provides many additional color palettes for the 
\href{https://www.uni-konstanz.de}{University of Konstanz}.
}
\examples{
uni_konstanz_2
unikn::seecol(uni_konstanz_2, main = "Preferred colors of the University of Konstanz")  
unikn::demopal(uni_konstanz_2, type = 3, main = "Preferred colors of the Uni Konstanz")

}
\seealso{
\code{\link{uni_konstanz_1}} for the default colors of the University of Konstanz;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-10-20.
}
\concept{German university color palettes}
\keyword{datasets}
