% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_locate.R
\name{vl_locate}
\alias{vl_locate}
\title{Get the nearest point on the road network}
\usage{
vl_locate(
  loc,
  verbose = FALSE,
  costing = "auto",
  costing_options = list(),
  server = getOption("valh.server")
)
}
\arguments{
\item{loc}{one (or multiples) point(s) to snap to the street network.
\code{loc} can be: \itemize{
  \item a vector of coordinates (longitude and latitude, WGS 84),
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}}

\item{verbose}{logical indicating whether to return additional information.}

\item{costing}{costing model to use.}

\item{costing_options}{list of options to use with the costing model
(see \url{https://valhalla.github.io/valhalla/api/turn-by-turn/api-reference/#costing-options}
for more details about the options available for each costing model).}

\item{server}{URL of the Valhalla server.}
}
\value{
If there is only one input point, return a single sf object
containing the nearest point(s) on the road network.
If there is more than one input point, return a list of sf objects,
one for each input point.
}
\description{
This function interfaces with the \emph{locate} Valhalla service.
}
\examples{
\dontrun{
# Inputs are data frames
apotheke.df <- read.csv(system.file("csv/apotheke.csv", package = "valh"))

loc <- apotheke.df[1, c("lon", "lat")]

# Ask for the nearest point on the road network at this point
# using "auto" costing model
on_road_1 <- vl_locate(loc = loc)

# Inputs are sf points
library(sf)
apotheke.sf <- st_read(system.file("gpkg/apotheke.gpkg", package = "valh"),
  quiet = TRUE
)

# Ask for one point
locsf1 <- apotheke.sf[1, ]
# The result is a single sf object
on_road_2 <- vl_locate(loc = locsf1)

# Ask for multiple points
locsf2 <- apotheke.sf[1:3, ]
# The result is a list of sf objects
on_road_3 <- vl_locate(loc = locsf2)
}
}
