% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca_pvar.R
\name{extract_cca_loadings}
\alias{extract_cca_loadings}
\title{Extract Top CCA Loadings}
\usage{
extract_cca_loadings(
  cca_result,
  n_top = 5L,
  which_matrix = c("both", "X", "Y")
)
}
\arguments{
\item{cca_result}{Result from run_sparse_cca.}

\item{n_top}{Number of top variables to show. Default 5.}

\item{which_matrix}{Character. "X", "Y", or "both". Default "both".}
}
\value{
Data frame with top loadings.
}
\description{
Extracts the variables with highest absolute loadings for each CCA component.
}
\examples{
set.seed(123)
n <- 50
p <- 20
X <- matrix(rnorm(n * p), n, p)
Y <- X \%*\% matrix(rnorm(p * 5), p, 5) + matrix(rnorm(n * 5, 0, 0.5), n, 5)
colnames(X) <- paste0("X", 1:p)
colnames(Y) <- paste0("Y", 1:5)

cca_res <- run_sparse_cca(X, Y, n_components = 2)
top_loads <- extract_cca_loadings(cca_res)
print(top_loads)

}
