% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modFit.R
\name{modFit}
\alias{modFit}
\alias{modFit.loglm}
\alias{modFit.glm}
\title{Brief Summary of Model Fit for a glm or loglm Object}
\usage{
modFit(x, ...)

\method{modFit}{glm}(x, stats = "chisq", digits = 2, ...)

\method{modFit}{loglm}(x, stats = "chisq", digits = 2, ...)
}
\arguments{
\item{x}{A \code{glm} or \code{loglm} object}

\item{\dots}{Arguments passed down}

\item{stats}{statistics to print: one or more of \code{"chisq"}, \code{"aic"}}

\item{digits}{number to digits to use in the print method}
}
\value{
A character string containing the formatted values of the chosen statistics.
}
\description{
Formats a brief summary of model fit for a \code{glm} or \code{loglm}
object, showing the likelihood ratio Chisq (df) value and or AIC.  Useful
for inclusion in a plot title or annotation.
}
\examples{

data(Mental)
require(MASS)
(Mental.tab <- xtabs(Freq ~ ses + mental, data=Mental))
(Mental.mod <- loglm(~ses + mental, Mental.tab))
Mental.mod
modFit(Mental.mod)

# use to label mosaic()
mosaic(Mental.mod, main=paste("Independence model,", modFit(Mental.mod)))

}
\seealso{
\code{\link{LRstats}}
}
\author{
Michael Friendly
}
\keyword{models}
\keyword{utilities}
