% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.propratio.ps}
\alias{se.propratio.ps}
\title{Computes the estimate and standard error for a paired-samples log
proportion ratio}
\usage{
se.propratio.ps(f00, f01, f10, f11)
}
\arguments{
\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated log proportion ratio
\item SE - standard error
}
}
\description{
Computes a large-sample standard error of a paired-samples log proportion
ratio using the frequency counts from a 2 x 2 contingency table. The log
proportion ratio and standard error output from this function can be used
as input in the \link[vcmeta]{meta.ave.gen.log} function in applications
where compatible proportion ratios from a combination of 2-group and
paired-samples studies are used in the meta-analysis.
}
\examples{
se.propratio.ps(16, 64, 5, 15)

# Should return:
#                         Estimate         SE
# Log proportion ratio:  -1.373716  0.2089758


}
