% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_xyz0.R
\name{region_xyz0}
\alias{region_xyz0}
\title{Planar region \eqn{\{(x, y): a \leq x \leq b, H1(x) \leq y \leq H2(x)\}} drawn at height z0}
\usage{
region_xyz0(
  H1,
  H2,
  a,
  b,
  z0,
  D,
  plot = TRUE,
  n_curve = 800,
  show_surface = FALSE,
  surface_colorscale = "Blues",
  surface_opacity = 0.3,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  boundary_line = list(color = "blue", width = 2),
  partition_line = list(color = "blue", width = 1),
  show_end_edges = TRUE,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)

region_xyz0(
  H1,
  H2,
  a,
  b,
  z0,
  D,
  plot = TRUE,
  n_curve = 800,
  show_surface = FALSE,
  surface_colorscale = "Blues",
  surface_opacity = 0.3,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  boundary_line = list(color = "blue", width = 2),
  partition_line = list(color = "blue", width = 1),
  show_end_edges = TRUE,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{H1, H2}{Functions \code{H_i(x)}; lower and upper y-boundaries.}

\item{a, b}{Numeric scalars; x-interval endpoints with \eqn{a < b}.}

\item{z0}{Numeric scalar; height of the display plane \eqn{z = z_0}.}

\item{D}{Integer > 0; number of x-partitions (controls vertical slices
and grid density).}

\item{plot}{Logical; if \code{TRUE}, draw the region with \pkg{plotly}.}

\item{n_curve}{Integer; number of samples used to trace each boundary
curve \eqn{y = H_i(x)}.}

\item{show_surface}{Logical; if \code{TRUE}, draw a thin surface patch of
the region at \eqn{z = z_0}.}

\item{surface_colorscale}{Character; Plotly colorscale for the surface
patch (for example, \code{"Blues"}).}

\item{surface_opacity}{Numeric in \eqn{[0,1]}; opacity of the surface
patch.}

\item{show_surface_grid}{Logical; show grid/contours on the surface patch.}

\item{surface_grid_color}{Character; color for surface grid lines.}

\item{surface_grid_width}{Numeric; width for surface grid lines.}

\item{boundary_line}{List; style for the boundary polylines (for example,
\code{list(color = "blue", width = 2)}).}

\item{partition_line}{List; style for the partition lines at
\eqn{x = a + k (b - a) / D}.}

\item{show_end_edges}{Logical; draw edges at \eqn{x = a} and \eqn{x = b}.}

\item{scene}{List; Plotly 3D scene options.}

\item{bg}{List with \code{paper} and \code{plot} background colors.}
}
\value{
A list with components:
\describe{
\item{\code{data}}{List (or tibble, depending on the implementation)
with the sampled curves and/or the grid used.}
\item{\code{plot}}{A \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL}.}
}

A list with components:
\describe{
\item{\code{data}}{List (or tibble, depending on the implementation)
with the sampled curves and/or the grid used.}
\item{\code{plot}}{A \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL}.}
}
}
\description{
Builds the planar region
\deqn{\Omega = \{(x,y):\ a \le x \le b,\ H_1(x) \le y \le H_2(x)\}}
and renders it as a thin patch on the plane \eqn{z = z_0}. Optionally it
draws the boundary curves, partition lines along \eqn{x}, and a surface
patch.

Builds the planar region defined by
\eqn{a \le x \le b} and \eqn{H_1(x) \le y \le H_2(x)}, and renders it as
a thin patch on the plane \eqn{z = z_0}. Optionally it draws the boundary
curves, partition lines along \eqn{x}, and a surface patch.
}
\examples{
H1 <- function(x) 0
H2 <- function(x) 1 - x
# Region under H2 and above H1 in [0,1], drawn at z = 0
# region_xyz0(H1, H2, a = 0, b = 1, z0 = 0,
#             D = 20, plot = TRUE, show_surface = TRUE)

H1 <- function(x) 0
H2 <- function(x) 1 - x
# Region under H2 and above H1 in [0,1], drawn at z = 0
# region_xyz0(H1, H2, a = 0, b = 1, z0 = 0,
#             D = 20, plot = TRUE, show_surface = TRUE)

}
