% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemann_sum_2d_plot.R
\name{riemann_sum_2d_plot}
\alias{riemann_sum_2d_plot}
\title{2D Riemann sums (upper, lower, midpoint) with a 3D plot}
\usage{
riemann_sum_2d_plot(
  f,
  xlim,
  ylim,
  nx = 8,
  ny = 8,
  methods = c("lower", "upper", "mid"),
  show_surface = TRUE,
  surface_res = c(60L, 60L),
  surface_colorscale = "Viridis",
  surface_opacity = 0.5,
  base_plane = TRUE,
  z0 = 0,
  base_opacity = 0.15,
  base_color = "lightgray",
  show_base_grid = TRUE,
  grid_color = "gray50",
  grid_width = 1,
  tile_opacity = 0.92,
  colors = list(lower = "#a1d99b", upper = "#fc9272", mid = "#9ecae1"),
  edge_color = "black",
  edge_width = 1.2,
  warn_heavy = TRUE
)
}
\arguments{
\item{f}{\code{function(x, y)} returning a numeric scalar \eqn{f(x,y)}.}

\item{xlim, ylim}{Numeric length-2 vectors \code{c(min, max)} for the domain.}

\item{nx, ny}{Positive integers: number of subintervals along \eqn{x} and \eqn{y}.}

\item{methods}{Character vector with any of \code{c("lower","upper","mid")}.
Controls which Riemann tiles are drawn. (All estimates are returned.)}

\item{show_surface}{Logical; if \code{TRUE} overlays the true surface \eqn{z=f(x,y)}.}

\item{surface_res}{Integer vector \code{c(nx_s, ny_s)} for the surface mesh.}

\item{surface_colorscale}{Plotly colorscale for the true surface (e.g. \code{"Viridis"}).}

\item{surface_opacity}{Opacity of the true surface (0–1).}

\item{base_plane}{Logical; if \code{TRUE} draws a faint base plane at \code{z0}.}

\item{z0}{Numeric; height of the base plane (typically 0).}

\item{base_opacity}{Opacity of the base plane (0–1).}

\item{base_color}{Color of the base plane.}

\item{show_base_grid}{Logical; if \code{TRUE} draws partition grid lines on the base plane.}

\item{grid_color}{Color of the base grid lines.}

\item{grid_width}{Line width of the base grid.}

\item{tile_opacity}{Opacity of Riemann tiles (0–1).}

\item{colors}{Named list for tile colors (hex or rgba), e.g.:
\code{list(lower="#a1d99b", upper="#fc9272", mid="#9ecae1")}.}

\item{edge_color}{Edge color for vertical edges of tiles.}

\item{edge_width}{Line width for tile edges.}

\item{warn_heavy}{Logical; if \code{TRUE}, warns when \code{nx*ny} is large.}
}
\value{
A list with:
\itemize{
\item \code{lower_sum}, \code{upper_sum}, \code{mid_sum}: numeric estimates,
\item \code{dx}, \code{dy}: partition widths,
\item \code{breaks}: list with \code{x_breaks}, \code{y_breaks},
\item \code{figure}: the \pkg{plotly} object (or \code{NULL} if \pkg{plotly} is not available).
}
}
\description{
Visualize 2D Riemann sums for a scalar field \eqn{f(x,y)} over a rectangular
domain \eqn{[x_{\min},x_{\max}]\times[y_{\min},y_{\max}]}. The function
computes upper, lower, and midpoint sums and renders a 3D figure
showing step tiles for the selected methods. Optionally overlays the true
surface \eqn{z=f(x,y)} and a base grid on the \eqn{xy}-plane.
}
\details{
Upper/lower tiles use corner samples (minimum/maximum of the four corners), and the
midpoint tiles sample at the cell center.
}
\examples{
\dontshow{if (interactive()) \{}
f <- function(x, y) exp(-(x^2 + y^2)) * (1 + 0.3 * cos(3*x) * sin(2*y))
out <- riemann_sum_2d_plot(
  f, xlim = c(-2, 2), ylim = c(-2, 2),
  nx = 8, ny = 7, methods = c("lower","mid","upper"),
  show_surface = TRUE, surface_res = c(80, 80),
  surface_colorscale = "YlGnBu", surface_opacity = 0.45
)
out$lower_sum; out$mid_sum; out$upper_sum
\dontshow{\}}

}
