% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{authenticate}
\alias{authenticate}
\title{Authenticate with the `Via Foundry` API}
\usage{
authenticate(
  hostname,
  username = NULL,
  password = NULL,
  identity_type = 1,
  redirect_uri = "http://localhost",
  config_path = DEFAULT_CONFIG_PATH,
  overwrite = FALSE
)
}
\arguments{
\item{hostname}{The API url.}

\item{username}{The login username.}

\item{password}{The login password (optional; will prompt if not provided).}

\item{identity_type}{The identity type (default is 1).}

\item{redirect_uri}{The redirect `URI`.}

\item{config_path}{Path to save the configuration file.}

\item{overwrite}{Logical flag to overwrite the existing configuration file (default is FALSE).}
}
\value{
None. Saves the bearer token to the configuration file and sets the global config path.
}
\description{
Authenticates the user with the `Via Foundry API` using their username and password.
Retrieves a bearer token and saves it along with the `API url` to a configuration file.
}
