% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{ca_ae}
\alias{ca_ae}
\title{Correspondence Analysis of Adverse Events}
\usage{
ca_ae(
  data,
  id,
  group,
  ae_class,
  label = "AE",
  contr_indicator = TRUE,
  mass_indicator = TRUE,
  contr_threshold = NULL,
  mass_threshold = NULL
)
}
\arguments{
\item{data}{data.frame or tibble object.}

\item{id}{unquoted expression indicating the
variable name in \code{data} that corresponds to the id variable.}

\item{group}{unquoted expression indicating the
variable name in \code{data} that corresponds to the group variable.}

\item{ae_class}{unquoted expression indicating the
variable name in \code{data} that corresponds to AE class.}

\item{label}{character value indicating the
column name of AE class in resulting tables.}

\item{contr_indicator}{logical value indicating the
use of color intensity to represent the maximum contribution of each \code{ae_class}.}

\item{mass_indicator}{logical value indicating the
use of dot size to represent the overall relative frequency of each \code{ae_class}.}

\item{contr_threshold}{numerical value between 0 an 1 filtering
\code{ae_class} with contribution greater than \code{contr_threshold}.}

\item{mass_threshold}{numerical value between 0 an 1 filtering
\code{ae_class} with mass greater than \code{mass_threshold}.}
}
\value{
a list of
\item{tab_abs}{a tibble showing absolute frequency of \code{ae_class} by \code{group};}
\item{tab_rel}{a tibble showing percent of \code{ae_class} by \code{group};}
\item{total_inertia}{a numerical value indicating the total inertia;}
\item{tab_inertia}{a tibble showing inertia broken down by dimension and the percent relative to the total inertia;}
\item{asymmetric_plot}{a contribution biplot.}
}
\description{
Correspondence Analysis of Adverse Events
}
\examples{
library(dplyr)

id <- rep(1:50, each = 2)
group <- c(rep("A", 50), rep("B", 50))
ae_grade <- sample(1:5, size = 100, replace = TRUE)
ae_domain <- sample(c("D", "E"), size = 100, replace = TRUE)
ae_term <- sample(c("F", "G", "H", "I"), size = 100, replace = TRUE)
df <- tibble(id = id, trt = group,
            ae_g = ae_grade, ae_d = ae_domain, ae_t = ae_term)
test <- df |> ca_ae(id = id,
                   group = trt,
                   ae = ae_g,
                   label = "AE",
                   contr_indicator = TRUE,
                   mass_indicator = TRUE,
                   contr_threshold = 0.01,
                   mass_threshold = 0.01)

}
\references{
Levine RA, Sampson E, Lee TC. Journal of Computational and Graphical Statistics. Wiley Interdisciplinary Reviews: Computational Statistics. 2014 Jul;6(4):233-9.
}
