% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualFields.R
\docType{package}
\name{visualFields-package}
\alias{visualFields}
\alias{visualFields-package}
\title{visualFields: statistical methods for visual fields}
\description{
visualFields is a collection of tools for analyzing the field of vision.
It provides a framework for development and use of innovative methods
for visualization, statistical analysis, and clinical interpretation
of visual-field loss and its change over time. It is intended to be a
tool for collaborative research.
}
\details{
The development version of visualFields 1.x, can be found in
\url{https://github.com/imarinfr/vf1}. For developers who want to collaborate
extending, updating, and patching visualFields, all necessary imports are to
be added to the source file \code{visualFields.R}. visualField developers can
use the source codes here as examples on how to craft new source code and keep
documentation that is consistent with the rest of the package, roxygen2, and CRAN.

The previous version of visualFields, 0.6, is still available for use in
\url{https://github.com/imarinfr/vf0}, but is no longer maintained.

This work was supported by the NIH grant number \bold{R01EY007716} and 
the Veterans Administration grant number \bold{I01 RX-001821-01A1}.
}
\references{
Marín-Franch I & Swanson WH. \emph{The visualFields package: A tool for
analysis and visualization of visual fields}. Journal of Vision, 2013,
13(4):10, 1-12

Turpin A, Artes PH, & McKendrick AM. \emph{The Open Perimetry Interface:
An enabling tool for clinical visual psychophysics}. Journal of Vision,
2012, 12(11):22, 21–25
}
\seealso{
\code{OPI}: the Open Perimetry Initiative
\url{https://opi.lei.org.au/} and \url{https://www.optocom.es/opi/}
}
\author{
\strong{Maintainer}: Ivan Marin-Franch \email{imarinfr@optocom.es} [reviewer, copyright holder]

Other contributors:
\itemize{
  \item William H Swanson [funder, data contributor]
  \item Michael Wall [funder, data contributor]
  \item Andrew Turpin [contributor]
  \item Paul H Artes [contributor, data contributor]
  \item Cord Huchzermeyer [contributor]
  \item Giovanni Montesano [contributor]
  \item Mitchell W Dul [data contributor]
}

}
