% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_items_grouped}
\alias{effect_metrics_items_grouped}
\title{Compare groups for each item by calculating F-statistics and effect sizes}
\usage{
effect_metrics_items_grouped(
  data,
  cols,
  cross,
  adjust = "fdr",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{The column holding groups to compare.}

\item{adjust}{Performing multiple significance tests inflates the alpha error.
Thus, p values need to be adjusted according to the number of tests.
Set a method supported by  \code{stats::\link[stats:p.adjust]{p.adjust}},
e.g. "fdr" (the default) or "bonferroni". Disable adjustment with FALSE.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker tibble with the following statistical measures:
\itemize{
\item \strong{Eta-squared}: Effect size indicating the proportion of variance in the dependent variable explained by the predictor.
\item \strong{Eta}: Root of Eta-squared, a standardized effect size.
\item \strong{n}: Number of cases the calculation is based on.
\item \strong{F}: F-statistic from the linear model.
\item \strong{p}: p-value for the statistical test.
\item \strong{stars}: Significance stars based on p-value (*, **, ***).
}
}
\description{
The models are fitted using \code{stats::\link[stats:lm]{lm}}.
ANOVA of type II is computed for each fitted model using \code{car::\link[car:Anova]{Anova}}.
Eta Squared is calculated for each ANOVA result
using \code{effectsize::\link[effectsize:eta_squared]{eta_squared}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics(data, starts_with("cg_adoption_"), adopter)

}
\keyword{internal}
