% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_wave_data.R
\name{fetch_wave_data}
\alias{fetch_wave_data}
\title{Fetch WAVE Analysis Data}
\usage{
fetch_wave_data(
  input,
  api_key = NULL,
  report_type = 1,
  is_json = FALSE,
  delay = 1
)
}
\arguments{
\item{input}{Character vector. Either URLs to analyze or paths to JSON files}

\item{api_key}{Character string. WAVE API key (required for URL analysis)}

\item{report_type}{Integer. WAVE report type (1-4):
\itemize{
\item 1: Basic statistics only (1 credit)
\item 2: Includes WAVE items (2 credits)
\item 3: Includes XPath data (3 credits)
\item 4: Includes CSS selector data (3 credits)
}}

\item{is_json}{Logical. Whether input contains JSON file paths (default: FALSE)}

\item{delay}{Numeric. Delay between API calls in seconds (default: 1)}
}
\value{
List of WAVE analysis results
}
\description{
Retrieves accessibility analysis data either from WAVE API or local JSON files
}
\examples{
\dontrun{
# Fetch from URLs
results <- fetch_wave_data(
  input = c("https://example.com", "https://example.org"),
  api_key = "your_api_key"
)

# Load from JSON files
json_results <- fetch_wave_data(
  input = c("site1.json", "site2.json"),
  is_json = TRUE
)
}
}
