% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penvs_userBgExtent.R
\name{penvs_userBgExtent}
\alias{penvs_userBgExtent}
\title{penvs_userBgExtent: user provided background extent}
\usage{
penvs_userBgExtent(
  bgShp_path,
  bgShp_name,
  userBgBuf,
  occs,
  logger = NULL,
  spN = NULL
)
}
\arguments{
\item{bgShp_path}{path to the user provided shapefile or csv with vertex
coordinates.}

\item{bgShp_name}{name of the user provided shapefile or csv with vertex
coordinates.}

\item{userBgBuf}{buffer to be used in creating the background extent must
be >= 0.}

\item{occs}{data frame of cleaned or processed occurrences obtained from
components occs: Obtain occurrence data or, poccs: Process occurrence data.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL.}

\item{spN}{Species name.}
}
\value{
This function returns a SpatialPolygons object with the user
  provided shape (+ a buffer if userBgBuf >0). The polygon will be at least
  large enough to contain all occurrences.
}
\description{
This function generates a background area according to a user
  provided polygon and buffer.
}
\details{
This function is used in the select study region component. Here, the user
  provides either a shapefile or a csv with vertex coordinates with the
  desired shape for the background extent, the user may include a buffer to
  the given polygon. The buffered polygon must include all occurrences
  (occs) or function will return an error. The function returns a
  SpatialPolygons object of the desired extent (+ buffer).
}
\examples{
occs <- read.csv(system.file("extdata/Bassaricyon_neblina.csv",
                 package = "wallace"))[, 2:3]
occs$occID <- 1:nrow(occs)
pathShp <- list.files(system.file("extdata/shp", package = "wallace"),
                      full.names = TRUE)
nameShp <- list.files(system.file("extdata/shp", package = "wallace"),
                      full.names = FALSE)
userBgbf <- penvs_userBgExtent(bgShp_path = pathShp, bgShp_name = nameShp,
                               userBgBuf = 0.2, occs = occs)

}
\seealso{
\code{\link{penvs_drawBgExtent}}, \code{\link{penvs_bgExtent}},
  \code{\link{penvs_bgMask}} , \code{\link{penvs_bgSample}}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>

Andrea Paz <paz.andreita@gmail.com>

Bethany A. Johnson <bjohnso005@citymail.cuny.edu>
}
