% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_lending_types.R
\name{wdi_get_lending_types}
\alias{wdi_get_lending_types}
\title{Download lending types from the World Bank API}
\source{
https://api.worldbank.org/v2/lendingTypes
}
\usage{
wdi_get_lending_types(language = "en")
}
\arguments{
\item{language}{A character string specifying the language code for the API
response (default is "en" for English).}
}
\value{
A tibble with columns that typically include:
\describe{
\item{lending_type_id}{An integer for the lending type.}
\item{lending_type_iso2code}{A character string for the ISO2 code of the
lending type.}
\item{lending_type_name}{A description of the lending type (e.g., "IBRD",
"IDA").}
}
}
\description{
This function returns a tibble of supported lending types for querying the
World Bank API. The lending types classify countries based on the financial
terms available to them from the World Bank.
}
\details{
This function provides a reference for the supported lending types,
which classify countries according to the financial terms they are eligible
for under World Bank programs. The language parameter allows the results to
be returned in different languages as supported by the API.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Download all lending types in English
wdi_get_lending_types()
\dontshow{\}) # examplesIf}
}
