% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diurnal.R
\name{diurnalT}
\alias{diurnalT}
\title{Calculate the diurnal variation in air temperature with Parton and Logan, 1981}
\usage{
diurnalT(maxt, mint, doy, hour, latitude, A = 1.5, B = 4, C = 1)
}
\arguments{
\item{maxt}{maximum daily temperature}

\item{mint}{minimum daily temperature}

\item{doy}{day of year}

\item{hour}{hour from 1 to 24}

\item{latitude}{latitude in radials}

\item{A}{is the time lag in temperature after noon}

\item{B}{is coef that controls temperature decrease at night}

\item{C}{is the time lag for min temperature after sunrise}
}
\value{
A vector with diurnal air temperature
}
\description{
Calculate the diurnal variation in air temperature.
Parton WJ, Logan JA (1981) A model for diurnal variation in soil and air temperature. 
Agricultural Meteorology, 23, 205?216.
Codes copied from APSIM Utilities.cpp
}
\examples{
diurnalT(maxt = 20, mint = 10, doy  = 1, 
   hour = seq(from = 1, to = 23.99, by = 0.1), 
   latitude = -10, A = 1.5, B = 4, C = 1)
}
