% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-point_today.R
\name{point_today}
\alias{point_today}
\title{Weather Observed Today at a Point}
\usage{
point_today(lat, lon, timezone = -1, dir_numeric = FALSE)
}
\arguments{
\item{lat}{Latitude.}

\item{lon}{Longitude.}

\item{timezone}{The nominal timezone for the forecast. One of \code{OlsonNames()} or \code{-1} for local time. Defaults to \code{-1}.}

\item{dir_numeric}{\code{TRUE} for numeric directions, \code{FALSE} for character directions; defaults to \code{FALSE}.}
}
\value{
Simple features point corresponding to the given station identifier with recent meteorological forecast values for today.
}
\description{
Weather Observed Today at a Point
}
\examples{
# Produce a GT summary of the weather thus far for a given lat/lon
\donttest{
point_today(lat = 33, lon = -80) \%>\%
as.data.frame() \%>\%
 dplyr::mutate(time = as.POSIXct(time) \%>\% format("\%H:\%M")) \%>\%
  dplyr::select(time, temp, dewpoint, humidity, wind_speed)
 }
}
