% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_common_blocks}
\alias{whapi_common_blocks}
\title{Build common message blocks for Whapi interactive messages}
\usage{
whapi_common_blocks(to, body_text, header_text = NULL, footer_text = NULL)
}
\arguments{
\item{to}{Character(1). Recipient phone number in international format
(digits only, no \code{+}), or a group/channel id.}

\item{body_text}{Character(1). Main text of the interactive message body.}

\item{header_text}{Character(1), optional. Optional header text.}

\item{footer_text}{Character(1), optional. Optional footer text.}
}
\value{
A named list ready to be merged into a Whapi interactive message payload,
containing elements: \code{to}, \code{header} (if provided), \code{body}, and \code{footer}
(if provided).
}
\description{
Internal helper that constructs the standard structure shared by Whapi
interactive messages (\code{button}, \code{list}, \verb{mixed actions}, etc.).

It automatically normalizes the recipient (\code{to}) using
\code{\link[=whapi_normalize_to]{whapi_normalize_to()}}, and creates \code{header}, \code{body}, and \code{footer} blocks
only if the corresponding text is provided.
}
\details{
Many Whapi interactive endpoints (e.g., \code{messages/interactive}) require
the same basic structure:
\itemize{
\item \strong{to}: target number or chat id;
\item \strong{header}: optional text shown above the body;
\item \strong{body}: main message text (required);
\item \strong{footer}: optional small text shown below the body.
}

This helper ensures consistency and avoids repeating boilerplate code
when building different interactive message payloads.
}
\examples{
\dontrun{
# Minimal body only

whapi_common_blocks("5581999999999", body_text = "Choose an option below")

# With header and footer
whapi_common_blocks(
  to = "5581999999999",
  body_text   = "Do you confirm?",
  header_text = "Booking Confirmation",
  footer_text = "Reply now"
)
}
}
\seealso{
\code{\link[=whapi_send_quick_reply]{whapi_send_quick_reply()}}, \code{\link[=whapi_send_list]{whapi_send_list()}},
\code{\link[=whapi_send_mixed_actions]{whapi_send_mixed_actions()}}
}
