% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_quick_reply}
\alias{whapi_send_quick_reply}
\title{Send a WhatsApp interactive message with QUICK REPLY buttons (Whapi.Cloud)}
\usage{
whapi_send_quick_reply(
  to,
  body_text,
  buttons,
  header_text = NULL,
  footer_text = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character (length 1). Phone in E.164 digits (without "+") or group id.}

\item{body_text}{Character. Main body text.}

\item{buttons}{Data frame or list. Up to 3 items; fields: \code{title}, \code{id} (id auto-generated if missing).}

\item{header_text, footer_text}{Character (optional). Header/footer texts.}

\item{token}{Bearer token. Defaults to env var WHAPI_TOKEN.}

\item{timeout}{Numeric, request timeout in seconds. Default 30.}

\item{verbose}{Logical, print CLI messages. Default TRUE.}
}
\value{
A tibble with fields \code{id}, \code{to}, \code{status}, \code{timestamp}, and raw response \code{resp}.
}
\description{
Sends an interactive message of type \strong{QUICK REPLY} via Whapi.
Each button is normalized/validated by \code{\link[=whapi_coerce_buttons_quick]{whapi_coerce_buttons_quick()}} and
automatically gets a unique slugified \code{id} if missing.
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_send_quick_reply(
   to = "5581999999999",
   body_text = "Do you confirm?",
   buttons = tibble::tribble(~title, "YES", "NO")
 )
}
}
\seealso{
\code{\link[=whapi_coerce_buttons_quick]{whapi_coerce_buttons_quick()}}, \code{\link[=whapi_common_blocks]{whapi_common_blocks()}}, \code{\link[=whapi_perform_request]{whapi_perform_request()}}
}
