% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_validation.R
\name{validate_inputs}
\alias{validate_inputs}
\title{Validates Inputs For \code{\link[=single_mab_simulation]{single_mab_simulation()}} and \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}}
\usage{
validate_inputs(
  data,
  assignment_method,
  algorithm,
  prior_periods,
  perfect_assignment,
  whole_experiment,
  blocking,
  data_cols,
  block_cols,
  time_unit,
  period_length,
  control_augment,
  verbose,
  ndraws,
  random_assign_prop
)
}
\arguments{
\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{assignment_method}{A character string; one of "date", "batch", or "individual", to define the assignment into treatment waves. When using
"batch" or "individual", ensure your dataset is pre-arranged in the proper order observations should be considered so that
groups are assigned correctly. For "date", observations will be considered in chronological order.
"individual" assignment can be computationally intensive for larger datasets.}

\item{algorithm}{A character string specifying the MAB algorithm to use. Options are "thompson" or "ucb1". Algorithm
defines the adaptive assignment process. Mathematical details on these algorithms
can be found in \href{https://arxiv.org/abs/1402.6028}{Kuleshov and Precup 2014} and
\href{https://arxiv.org/abs/1904.07272}{Slivkins 2024}.}

\item{prior_periods}{A numeric value of length 1, or the character string "All"; number of previous periods to use
in the treatment assignment model. This is used to implement the stationary/non-stationary bandit.
For example, a non-stationary bandit assumes the true probability of success for each treatment changes over time, so to
account for that, not all prior data should be used when making decisions because it could be "out of date".}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{whole_experiment}{Logical; if TRUE, uses all past experimental data for imputing outcomes.
If FALSE, uses only data available up to the current period. In large datasets or with a high number
of periods, setting this to FALSE can be more computationally intensive, though not a significant
contributor to total run time.}

\item{blocking}{Logical; whether or not to use treatment blocking. Treatment blocking is used to ensure an even-enough
distribution of treatment conditions across blocks. For example, blocking by gender would mean the randomized assignment should
split treatments evenly not just throughout the sample (so for 4 arms, 25-25-25-25), but also within each block, so 25\% of men
would receive each treatment and 25\% of women the same.}

\item{data_cols}{A named character vector containing the names of columns in \code{data} as strings:
\itemize{
\item \code{id_col}: Column in \code{data}; contains unique ID as a key.
\item \code{success_col}: Column in \code{data}; binary successes from the original experiment.
\item \code{condition_col}: Column in \code{data}; original treatment condition for each observation.
\item \code{date_col}: Column in \code{data}; contains original date of event/trial. Only necessary when assigning by "Date". Must be of type \code{Date}, not a character string.
\item \code{month_col}: Column in \code{data}; contains month of treatment. Only necessary when \code{time_unit = "Month"}, and when periods should be determined directly by
the calendar months instead of month based time periods. This column can be a string/factor variable with the month names or numeric with the month number. It can easily
be created from your \code{date_col} via \code{lubridate::month(data[[date_col]])} or \code{format(data[[date_col]], "\%m")}.
\item \code{success_date_col}: Column in \code{data}; contains original dates each success occurred. Only necessary when \code{perfect_assignment = FALSE}. Must be of type \code{Date}, not a character string.
\item \code{assignment_date_col}: Column in \code{data}; contains original dates treatments were assigned to observations. Only necessary when \code{perfect_assignment = FALSE}.
Used to simulate imperfect information on the part of researchers conducting an adaptive trial. Must be of type \code{Date}, not a character string.
}}

\item{block_cols}{A character vector of variables to block by. This vector should not be named.}

\item{time_unit}{A character string specifying the unit of time for assigning periods when \code{assignment_method} is "date".
Acceptable values are "day", "week", or "month". "month" does not require an additional column with the months of each observation,
but it can accept a separate \code{month_col}. If \code{month_col} is specified, the periods follow the calendar months strictly, and when it is not
specified months are simply used as the time interval. For example if a dataset has dates starting on July 26th, under month based assignment and
a specified \code{month_col} the dates July 26th and August 3st would be in different periods, but if the \code{month_col} was not specified, they would be
in the same period because the dates are less than one month apart.}

\item{period_length}{A numeric value of length 1; represents the length of each treatment period.
If assignment method is "date", this length refers the number of units specified in \code{time_unit}
(i.e., if "day", 10 would be 10 days). If assignment method is "batch", this refers to the number of people in each batch.}

\item{control_augment}{A numeric value ranging from 0 to 1; proportion of each wave guaranteed to receive the "Control" treatment.
Default is 0. It is not recommended to use this in conjunction with \code{random_assign_prop}.}

\item{verbose}{Logical; whether or not to print intermediate messages. Default is FALSE.}

\item{ndraws}{A numeric value; When Thompson sampling direct calculations fail, draws from a simulated posterior
will be used to approximate the Thompson sampling probabilities. This is the number of simulations to use, the default
is 5000 to match the default parameter \code{\link[bandit:best_binomial_bandit_sim]{bandit::best_binomial_bandit_sim()}}, but might need to be raised or lowered depending on performance and accuracy
concerns.}

\item{random_assign_prop}{A numeric value ranging from 0 to 1; proportion of each wave to be assigned new treatments randomly,
1 - \code{random_assign_prop} is the proportion assigned through the bandit procedure. For example if this is set to 0.1, then
for each wave 10\% of the observations will be randomly assigned to a new treatment, while the remaining 90\% will be assigned according
to UCB1 or Thompson result. It is not recommended to use this in conjunction with \code{control_augment}. If batch sizes are small,
and the number of rows is calculate to be less than 1, and probability sampling approach is used where each row in the batch
will have a \code{random_assign_prop} probability of being selected for random assignment. Otherwise the number is rounded to
a whole number, and that many rows are selected for random assignment.}
}
\value{
Throws an error if an argument is missing or misspecified.
}
\description{
This function checks to ensure that all required arguments
have been properly passed to the function before continuing with the simulation. When
errors are thrown, user-friendly messages are provided to indicate which argument
was misspecified. Additionally, when \code{verbose} = TRUE, additional warning
messages may be shown if unnecessary arguments are passed.
}
\seealso{
\itemize{
\item \code{\link[=single_mab_simulation]{single_mab_simulation()}}
\item \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}
}
}
\keyword{internal}
