% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ca.R
\name{Ca}
\alias{Ca}
\title{Coefficient of Association}
\usage{
Ca(traj, traj2, tc = 0, dc = 0)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{tc}{temporal tolerance limit (in seconds) for defining when two fixes
are simultaneous or together. Parameter passed to function \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when 
two fixes are spatially together.}
}
\value{
This function returns a numeric result of the Ca statistic for each pair in the dataset.
}
\description{
This function measures the dynamic interaction between two moving objects following
 the methods first described by Cole (1949), and more recently employed by Bauman (1998).
}
\details{
This function can be used to calculate the Cole (1949) measure of dynamic
 interaction between two animals. Termed a coefficient of association, the Ca
 statistic tests the number of fixes the animals are observed together against the
 total number of fixes following:
 \deqn{Ca = \frac{2AB}{A+B}}{2AB/(A+B)}
 where \eqn{A} (respectively \eqn{B}) is the number of times animal 1 (resp. 2) are
 observed, and \eqn{AB} is the number of times the two animals are observed together.
 Several works, including Bauman (1998) have suggested that Ca > 0.5 indicates
 affiliation or fidelity, while Ca < 0.5 indicates no association between the
 two animals. Note that this function calls \code{GetSimultaneous} to identify the temporal
 component of identifying when fixes together.
}
\examples{
data(deer)
#tc = 7.5 minutes, dc = 50 meters
Ca(deer, tc = 7.5*60, dc = 50)

}
\references{
Bauman, P.J. (1998) The Wind Cave National Park elk herd: home ranges, seasonal movements, and alternative control methods.
   M.S. Thesis. South Dakota State University, Brookings, South Dakota, USA. \cr\cr
 Cole, L.C. (1949) The measurement of interspecific association. \emph{Ecology}. \bold{30}, 411--424.
}
\seealso{
GetSimultaneous, Prox, HAI
}
\keyword{indices}
