% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readerFuncs.R
\name{read_amax}
\alias{read_amax}
\title{A function to read .AM files}
\usage{
read_amax(station, loc_WinFapFiles = getwd())
}
\arguments{
\item{station}{NRFA station number(s) for which the .AM file (named \code{station.AM}) should be read.}

\item{loc_WinFapFiles}{the file.path of the WINFAP files, i.e. the location in which the
\code{station.AM} file can be found. Default is the working directory}
}
\value{
a data.frame with information on the annual maxima for the station with the following columns
\describe{
 \item{Station}{NRFA station number (can be a vector of station numbers)}
 \item{WaterYear}{the correct water year for the peak flow}
 \item{Date}{date of maximum flow}
 \item{Flow}{the maximum flow in m3/s}
 \item{Stage}{the stage (height) reached by the river - this information is used to derive the flow via a rating curve}
 \item{Rejected}{logical, if TRUE the water year has been flagged as rejected by the NRFA}
}
}
\description{
The function reads .AM files once these are in a local folder: these files contain information on annual maxima (AMAX) records extracted from the instantaneous river flow measurements.
The function checks for the presence of any [AM Rejected] information and includes it in the output.
}
\seealso{
Information on the .AM files and river flow gauging in the UK can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}
}
