% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidationState.R
\name{ValidationState}
\alias{ValidationState}
\title{ValidationState R6 Class}
\description{
Manages NDA validation state and tracks modifications to data structures.
Central object for tracking validation results, modifications, and determining
whether data definition files need to be created.
}
\details{
This class replaces the fragile attribute-passing pattern used previously.
It provides a structured way to track:
\itemize{
\item Validation status (valid/invalid, new/existing structure)
\item Value range violations
\item New fields added
\item Required field status
\item Metadata from ndar_subject01
}

The key method \code{needs_data_definition()} determines whether a data definition
file should be created based on whether the structure is new or modified.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{measure_name}}{Character - name of the measure/structure}

\item{\code{api}}{Character - API type (redcap, qualtrics, mongo, etc.)}

\item{\code{data_env}}{DataEnvironment - manages dataframe across environments}

\item{\code{nda_structure}}{List - NDA structure definition from API}

\item{\code{is_valid}}{Logical - whether validation passed}

\item{\code{is_new_structure}}{Logical - whether structure is new (not in NDA)}

\item{\code{is_modified_structure}}{Logical - whether existing structure has modifications}

\item{\code{bypassed_validation}}{Logical - whether validation was bypassed (new structures)}

\item{\code{value_range_violations}}{List - fields with value range violations}

\item{\code{new_fields}}{Character vector - fields in data not in NDA structure}

\item{\code{ndar_subject_additions}}{Character vector - DCC fields added from ndar_subject01}

\item{\code{ndar_subject01_all_fields}}{Character vector - ALL field names from ndar_subject01 (~150 fields)
Used for consistent formatting in Excel exports regardless of dcc parameter}

\item{\code{renamed_fields}}{Character vector - fields that were renamed}

\item{\code{dropped_fields}}{Character vector - fields that were dropped}

\item{\code{missing_required}}{Character vector - required fields with missing data}

\item{\code{required_metadata}}{Data frame - ndar_subject01 required field metadata}

\item{\code{recommended_metadata}}{Data frame - ndar_subject01 recommended field metadata}

\item{\code{warnings}}{Character vector - warning messages}

\item{\code{errors}}{Character vector - error messages}

\item{\code{dcc}}{Logical - whether DCC fields should be validated}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ValidationState-new}{\code{ValidationState$new()}}
\item \href{#method-ValidationState-get_df}{\code{ValidationState$get_df()}}
\item \href{#method-ValidationState-set_df}{\code{ValidationState$set_df()}}
\item \href{#method-ValidationState-add_value_range_violation}{\code{ValidationState$add_value_range_violation()}}
\item \href{#method-ValidationState-add_violations}{\code{ValidationState$add_violations()}}
\item \href{#method-ValidationState-set_valid}{\code{ValidationState$set_valid()}}
\item \href{#method-ValidationState-has_modifications}{\code{ValidationState$has_modifications()}}
\item \href{#method-ValidationState-needs_data_definition}{\code{ValidationState$needs_data_definition()}}
\item \href{#method-ValidationState-get_modification_reason}{\code{ValidationState$get_modification_reason()}}
\item \href{#method-ValidationState-to_list}{\code{ValidationState$to_list()}}
\item \href{#method-ValidationState-print}{\code{ValidationState$print()}}
\item \href{#method-ValidationState-clone}{\code{ValidationState$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-new"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-new}{}}}
\subsection{Method \code{new()}}{
Create a new ValidationState instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$new(measure_name, api, df, nda_structure = NULL, dcc = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure_name}}{Name of the measure/structure}

\item{\code{api}}{API type (redcap, qualtrics, mongo, csv, oracle, sql)}

\item{\code{df}}{Initial dataframe}

\item{\code{nda_structure}}{NDA structure definition (NULL for new structures)}

\item{\code{dcc}}{Logical - whether DCC fields should be validated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new ValidationState object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-get_df"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-get_df}{}}}
\subsection{Method \code{get_df()}}{
Get current dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$get_df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-set_df"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-set_df}{}}}
\subsection{Method \code{set_df()}}{
Update dataframe in all environments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$set_df(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{New dataframe}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisibly) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-add_value_range_violation"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-add_value_range_violation}{}}}
\subsection{Method \code{add_value_range_violation()}}{
Add a value range violation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$add_value_range_violation(field, expected, actual)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{expected}}{Expected value range (NULL if no range defined)}

\item{\code{actual}}{Vector of violating values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisibly) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-add_violations"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-add_violations}{}}}
\subsection{Method \code{add_violations()}}{
Add violations of a specific type (e.g., DCC violations)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$add_violations(type, violations)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Character - type of violations ("dcc_required", "dcc_recommended", etc.)}

\item{\code{violations}}{List - violations to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisibly) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-set_valid"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-set_valid}{}}}
\subsection{Method \code{set_valid()}}{
Set validation status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$set_valid(valid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{valid}}{Logical - TRUE if validation passed, FALSE otherwise}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisibly) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-has_modifications"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-has_modifications}{}}}
\subsection{Method \code{has_modifications()}}{
Check if structure has modifications requiring data definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$has_modifications()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-needs_data_definition"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-needs_data_definition}{}}}
\subsection{Method \code{needs_data_definition()}}{
Determine if data definition file is needed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$needs_data_definition()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical - TRUE if data definition should be created
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-get_modification_reason"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-get_modification_reason}{}}}
\subsection{Method \code{get_modification_reason()}}{
Get human-readable modification reason
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$get_modification_reason()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string describing why structure is modified
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert to list for backward compatibility with old validation_results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List with validation results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-print"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-print}{}}}
\subsection{Method \code{print()}}{
Print method for ValidationState
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self (invisibly)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ValidationState-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ValidationState-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ValidationState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
