% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_isd_stations.R
\name{import_isd_stations}
\alias{import_isd_stations}
\title{Import station metadata for the Integrated Surface Databse}
\usage{
import_isd_stations(
  site = NULL,
  lat = NULL,
  lon = NULL,
  crs = 4326,
  country = NULL,
  state = NULL,
  n_max = 10,
  end_year = "current",
  provider = c("OpenStreetMap", "Esri.WorldImagery"),
  return = c("table", "sf", "map")
)
}
\arguments{
\item{site}{A site name search string e.g. \code{site = "heathrow"}. The search
strings and be partial and can be upper or lower case e.g. \code{site = "HEATHR"}.}

\item{lat, lon}{Decimal latitude and longitude (or other Y/X coordinate if
using a different \code{crs}). If provided, the \code{n_max} closest ISD stations to this
coordinate will be returned.}

\item{crs}{The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for making
comparisons with the NOAA metadata plotting on the map.}

\item{country}{The country code. This is a two letter code. For a full
listing see \url{https://www.ncei.noaa.gov/pub/data/noaa/isd-history.csv}.}

\item{state}{The state code. This is a two letter code.}

\item{n_max}{The number of nearest sites to search based on \code{latitude} and
\code{longitude}.}

\item{end_year}{To help filter sites based on how recent the available data
are. \code{end_year} can be "current", "any" or a numeric year such as 2016, or
a range of years e.g. 1990:2016 (which would select any site that had an
end date in that range. \strong{By default only sites that have some data for the
current year are returned}.}

\item{provider}{By default a map will be created in which readers may toggle
between a vector base map and a satellite/aerial image. \code{provider} allows
users to override this default; see
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{return}{The type of R object to import the ISD stations as. One of the
following:
\itemize{
\item \code{"table"}, which returns an R \code{data.frame}.
\item \code{"sf"}, which returns a spatial \code{data.frame} from the \code{sf} package.
\item \code{"map"}, which returns an interactive \code{leaflet} map.
}}
}
\value{
A data frame is returned with all available meta data, mostly
importantly including a \code{code} that can be supplied to \code{\link[=importNOAA]{importNOAA()}}. If
latitude and longitude searches are made an approximate distance, \code{dist} in
km is also returned.
}
\description{
This function is primarily used to find a site code that can be used to
access data using \code{\link[=import_isd_hourly]{import_isd_hourly()}}. Sites searches of approximately
30,000 sites can be carried out based on the site name and based on the
nearest locations based on user-supplied latitude and longitude.
}
\examples{
\dontrun{
## search for sites with name beijing
getMeta(site = "beijing")
}

\dontrun{
## search for near a specified lat/lon - near Beijing airport
## returns 'n_max' nearest by default
getMeta(lat = 40, lon = 116.9)
}
}
\seealso{
Other NOAA ISD functions: 
\code{\link{import_isd_hourly}()},
\code{\link{import_isd_lite}()},
\code{\link{import_isd_stations_live}()}
}
\author{
David Carslaw
}
\concept{NOAA ISD functions}
