% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_sumtrndseason.R
\name{anlz_sumtrndseason}
\alias{anlz_sumtrndseason}
\title{Estimate seasonal rates of change based on average estimates for multiple window widths}
\usage{
anlz_sumtrndseason(
  mod,
  doystr = 1,
  doyend = 364,
  justify = c("center", "left", "right"),
  win = 5:15,
  yromit = NULL
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{justify}{chr string indicating the justification for the trend window}

\item{win}{numeric vector indicating number of years to use for the trend window}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}
}
\value{
A data frame of slope estimates and p-values for each year
}
\description{
Estimate seasonal rates of change based on average estimates for multiple window widths
}
\details{
The optional \code{yromit} vector can be used to omit years from the plot and trend assessment. This may be preferred if seasonal estimates for a given year have very wide confidence intervals likely due to limited data, which can skew the trend assessments.

This function is a wrapper to \code{\link{anlz_trndseason}} to loop across values in \code{win}, using \code{useave = TRUE} for quicker calculation of average seasonal metrics.  It does not work with any other seasonal metric calculations.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
anlz_sumtrndseason(mod, doystr = 90, doyend = 180, justify = 'center', win = 2:3)
}
\seealso{
Other analyze: 
\code{\link{anlz_trans}()},
\code{\link{anlz_trndseason}()}
}
\concept{analyze}
