% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrds-connect.R
\name{wrds_set_credentials}
\alias{wrds_set_credentials}
\title{Set WRDS credentials}
\usage{
wrds_set_credentials(
  user_key = "wrds_user",
  password_key = "wrds_pw",
  keyring = NULL
)
}
\arguments{
\item{user_key}{Name for the username keyring entry. Defaults to \code{"wrds_user"}.}

\item{password_key}{Name for the password keyring entry. Defaults to \code{"wrds_pw"}.}

\item{keyring}{Optional keyring name. If \code{NULL} (default), uses the
default keyring.}
}
\value{
Invisibly returns \code{TRUE} on success.
}
\description{
Interactively stores WRDS username and password in the system keyring
for secure, persistent storage.
}
\details{
This function prompts for username and password interactively. Credentials
are stored securely using the operating system's keyring (Keychain on macOS,
Credential Manager on Windows, Secret Service on Linux).
}
\examples{
\dontrun{
wrds_set_credentials()
}
}
