% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARIVwrapper.R
\name{ARIVwrapper}
\alias{ARIVwrapper}
\title{Average Relative Increase in Variance}
\usage{
ARIVwrapper(between, within, M, k)
}
\arguments{
\item{between}{Numeric matrix.
Covariance between imputations
\eqn{\mathbf{V}_{\mathrm{between}}}.}

\item{within}{Numeric matrix.
Covariance within imputations
\eqn{\mathbf{V}_{\mathrm{within}}}.}

\item{M}{Positive integer.
Number of imputations.}

\item{k}{Positive integer.
Number of parameters.}
}
\value{
Returns a numeric vector of length one.
}
\description{
Average Relative Increase in Variance
}
\details{
The average relative increase in variance
is given by
\deqn{
    \mathrm{ARIV}
    =
    \left( 1 + M^{-1} \right)
    \mathrm{tr}
    \left(
       \mathbf{V}_{\mathrm{between}}
       \mathbf{V}_{\mathrm{within}}^{-1}
    \right)
  }
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{internal}
