% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MClav_RAM2Lav2.R
\name{RAM2Lav2}
\alias{RAM2Lav2}
\title{Convert Standardized RAM Back to Lavaan Matrices}
\usage{
RAM2Lav2(ram, lav_mod, standardized = FALSE)
}
\arguments{
\item{ram}{A RAM list containing standardized matrices (\code{A}, \code{S}, \code{F}, and \code{M}).}

\item{lav_mod}{A lavaan-style matrix list (e.g., GLIST) to be updated.}

\item{standardized}{Logical. If TRUE, forces symmetric matrices to correlation form (cov2cor).}
}
\value{
A modified lavaan-style matrix list with updated \code{lambda}, \code{beta}, \code{theta}, \code{psi}, and \code{alpha}.
}
\description{
Converts a standardized RAM object back to lavaan-style matrix structure.
Optionally ensures correlations for \code{theta} and \code{psi} matrices.
}
\details{
This function restores the internal lavaan model matrix structure from a RAM representation.
}
\keyword{internal}
