% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{CodonPrecision}
\alias{CodonPrecision}
\title{Compute codon precision with the choice bias of rules below a threshold.}
\usage{
CodonPrecision(cv, pCrit)
}
\arguments{
\item{cv}{Choice vector of a context-free grammar.}

\item{pCrit}{Threshold for choice bias.}
}
\value{
Precision of codon.
}
\description{
For automatic determination of the least codon precision for grammar evolution 
             with an upper threshold on the choice bias for the substitution of all
             non-terminal symbols.
}
\examples{
 CodonPrecision(c(1, 2, 3, 5), 0.1)
 CodonPrecision(c(1, 2, 3, 5), 0.01)

}
\seealso{
Other Diagnostics: 
\code{\link{CodonChoiceBiases}()},
\code{\link{CodonChoiceBiasesDeprecated}()},
\code{\link{tLCM}()}
}
\concept{Diagnostics}
