% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{DispersionMeasureFactory}
\alias{DispersionMeasureFactory}
\title{Configure dispersion measure.}
\usage{
DispersionMeasureFactory(method = "var")
}
\arguments{
\item{method}{A dispersion measure.
\itemize{
\item  "var": Variance (Default).
\item "std": Standard deviation.
\item "mad": Median absolute deviation (\code{mad(vec, constant=1)}).
\item "cv": Coefficient of variation". 
\item "range": Range.
\item "iqr": Inter quartile range 
       (approximated by the lower and upper hinge of \code{fivenum}). 
}
If an invalid label is 
specified, the configuration fails.}
}
\value{
A function which computes the dispersion measure from the vector of 
        population statistics produced by \code{xegaObservePopulation}
        of package \code{xegaPopulation}.
}
\description{
\code{DispersionMeasureFactory()} returns a function 
for the dispersion measure as specified by a label.
    If an invalid label is 
    specified, the configuration fails.
}
\examples{
require(stats)
fit<-sample(30, 20, replace=TRUE)
populationStats<-c(mean(fit), fivenum(fit), var(fit), mad(fit, constant=1))
dm<-DispersionMeasureFactory("var")
dm(populationStats)
dm<-DispersionMeasureFactory("range")
dm(populationStats)
}
\seealso{
Other Configuration: 
\code{\link{EvalGeneFactory}()},
\code{\link{ScalingFactory}()},
\code{\link{SelectGeneFactory}()}
}
\concept{Configuration}
