% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGene}
\alias{EvalGene}
\title{Evaluate a gene}
\usage{
EvalGene(gene, lF)
}
\arguments{
\item{gene}{A gene (representation independent).}

\item{lF}{The local configuration (a function factory provided by 
the \code{xegaX} package).}
}
\value{
A gene.
}
\description{
\code{EvalGene()} is the abstract function which evaluates 
             a gene.
}
\details{
For minimization problems, the fitness value 
         must be multiplied by -1. The constant function 
         \code{lF$Max()} returns 1 for a maximization and 
         -1 for a minimization problem.
}
\examples{
DeJongF4<-DeJongF4Factory()
lF<-NewlFevalGenes(DeJongF4)
EvalGene<-EvalGeneFactory()
g1<-list(evaluated=FALSE, fit=0, gene1=c(1.0, -1.5))
g1
g2<-EvalGene(g1, lF)
g2
}
\seealso{
Other Evaluation Functions: 
\code{\link{EvalGeneDet}()},
\code{\link{EvalGeneR}()},
\code{\link{EvalGeneStoch}()},
\code{\link{EvalGeneU}()}
}
\concept{Evaluation Functions}
