new_predxhaz <- function(time, hazard, survival,
                         baseline = c("constant","bsplines","unknown"),
                         attrs = list()) {
  baseline <- match.arg(baseline)
  stopifnot(length(time) == length(hazard),
            length(time) == length(survival))
  out <- list(
    time     = as.numeric(time),
    hazard   = as.numeric(hazard),
    survival = as.numeric(survival)
  )
  class(out) <- c("predxhaz","list")
  attr(out, "baseline") <- baseline
  if (length(attrs)) for (nm in names(attrs)) attr(out, nm) <- attrs[[nm]]
  out
}
