% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_xpm_3d}
\alias{plot_xpm_3d}
\title{generate 3d scatter plot from xpm data}
\usage{
plot_xpm_3d(xpm_data, reversescale = FALSE, point_size = 2)
}
\arguments{
\item{xpm_data}{a xpm object (from \code{\link[=read_xpm]{read_xpm()}}) or list containing parsed objects.}

\item{reversescale}{whether to reverse the color scale; default is FALSE}

\item{point_size}{the size of the points in the scatter plot; default is 2}
}
\value{
a plotly object
}
\description{
creates 3d visualization of xpm data with scatter plot.
}
\examples{
library(xvm)
xpm_file_path <- system.file("extdata/gibbs.xpm", package = "xvm")
xpm_data <- read_xpm(xpm_file_path)
plot_xpm_3d(xpm_data) # plot 3D scatter plot from xpm file
}
