% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_cashflow}
\alias{get_tickers_cashflow}
\title{Get cash flow statement for multiple tickers}
\usage{
get_tickers_cashflow(
  tickers_obj,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  cashflow_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{cashflow_keys}{Vector of specific cash flow statement keys to include (default all)
See \code{valid_cashflow_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
A list of tibbles with cash flow statement data for each ticker
}
\description{
Retrieves cash flow statement data from Yahoo Finance for multiple specified ticker symbols.
Cash flow statements show how changes in balance sheet accounts and income affect
cash and cash equivalents, breaking the analysis down to operating, investing, and
financing activities.
}
\details{
See \code{get_cashflow} for more details on the cash flow statement.
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_cashflow <- get_tickers_cashflow(tech_tickers)
}
}
