











#[must_use]
pub(crate) struct AbortIfPanic(pub(crate) &'static &'static str);

impl AbortIfPanic
{

    #[inline]
    pub(crate) fn defuse(self)
    {
        std::mem::forget(self);
    }
}

impl Drop for AbortIfPanic
{


    fn drop(&mut self)
    {
        #[cfg(feature = "std")]
        {
            eprintln!("ndarray: panic in no-panic section, aborting: {}", self.0);
            std::process::abort()
        }
        #[cfg(not(feature = "std"))]
        {

            panic!("ndarray: panic in no-panic section, bailing out: {}", self.0);
        }
    }
}
