use super::*;





#[derive(PartialEq, Clone)]
pub struct Primitive {
    pub(crate) robj: Robj,
}

impl Primitive {
    #[cfg(feature = "non-api")]
    
    
    
    
    
    
    
    
    
    
    pub fn from_string(val: &str) -> Result<Self> {
        single_threaded(|| unsafe {
            
            let sym = Symbol::from_string(val);
            let symvalue = Robj::from_sexp(extendr_ffi::SYMVALUE(sym.get()));
            if symvalue.is_primitive() {
                Ok(Primitive { robj: symvalue })
            } else {
                Err(Error::ExpectedPrimitive(sym.into()))
            }
        })
    }

    
}

impl std::fmt::Debug for Primitive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let s: String = self.robj.deparse().unwrap();
        write!(f, "{:?}", s)
    }
}
