/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BBMetric {
    private final boolean PARALLEL = false;
    private List<PlacementFrame.PlacementNetwork> allNetworks;
    private Map<PlacementFrame.PlacementNode, Integer> nodeBlocks;

    public BBMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.allNetworks = allNetworks;
        this.nodeBlocks = new HashMap<PlacementFrame.PlacementNode, Integer>();
        Iterator<PlacementFrame.PlacementNode> it = nodesToPlace.iterator();
        for (int i = 0; i < nodesToPlace.size(); ++i) {
            this.nodeBlocks.put(it.next(), i);
        }
    }

    public double compute(Block[] blocks) {
        double completeLength = 0.0;
        for (PlacementFrame.PlacementNetwork w : this.allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            if (w.getPortsOnNet().size() == 0) {
                System.out.println("HELP");
            }
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            for (PlacementFrame.PlacementPort p : pp) {
                int blockId = this.nodeBlocks.get(p.getPlacementNode());
                double offX = p.getOffX();
                double offY = p.getOffY();
                Orientation o = blocks[blockId].getOrientation();
                if (o != Orientation.IDENT) {
                    FixpTransform trans = o.pureRotate();
                    Point2D.Double offset = new Point2D.Double(offX, offY);
                    trans.transform(offset, offset);
                    offX = ((Point2D)offset).getX();
                    offY = ((Point2D)offset).getY();
                }
                double xpos = blocks[blockId].getX() + offX;
                double ypos = blocks[blockId].getY() + offY;
                if (xpos < left) {
                    left = xpos;
                }
                if (xpos > right) {
                    right = xpos;
                }
                if (ypos > top) {
                    top = ypos;
                }
                if (!(ypos < bottom)) continue;
                bottom = ypos;
            }
            completeLength += right - left + (top - bottom);
        }
        return completeLength;
    }

    public double compute() {
        double completeLength = 0.0;
        for (PlacementFrame.PlacementNetwork w : this.allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            if (w.getPortsOnNet().size() == 0) {
                System.exit(-1337);
            }
            double l = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double r = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double u = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            double d = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            for (PlacementFrame.PlacementPort p : pp) {
                double xpos = p.getPlacementNode().getPlacementX() + p.getRotatedOffX();
                double ypos = p.getPlacementNode().getPlacementY() + p.getRotatedOffY();
                if (xpos < l) {
                    l = xpos;
                } else if (xpos > r) {
                    r = xpos;
                }
                if (ypos < d) {
                    d = ypos;
                    continue;
                }
                if (!(ypos > u)) continue;
                u = ypos;
            }
            completeLength += r - l + (u - d);
        }
        return completeLength;
    }
}

