/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.PlacementFrameElectric;
import com.sun.electric.tool.placement.general.BottomUpPartition;
import com.sun.electric.tool.placement.general.BottomUpPlace;
import com.sun.electric.tool.placement.general.FDRowCol;
import com.sun.electric.tool.placement.general.RowCol;
import com.sun.electric.tool.placement.simulatedAnnealing2.PlacementSimulatedAnnealing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Control
extends PlacementFrameElectric {
    @Override
    public String getAlgorithmName() {
        return "General Placement";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        BottomUpPartition decomposeAlgorithm = PlacementAdapter.BUpa;
        decomposeAlgorithm.setEditingPreferences(this.ep);
        BottomUpPlace recomposeAlgorithm = PlacementAdapter.BUpl;
        recomposeAlgorithm.setEditingPreferences(this.ep);
        FDRowCol fixedPitchAlgorithm = PlacementAdapter.FD3;
        PlacementAdapter.FD3.makeStacksEven.setValue(Boolean.TRUE);
        PlacementSimulatedAnnealing nonFixedPitchAlgorithm = PlacementAdapter.SA2;
        Integer timeLimit = 30;
        Placement.PlacementPreferences ppIrregular = new Placement.PlacementPreferences(false);
        ppIrregular.placementAlgorithm = nonFixedPitchAlgorithm.getAlgorithmName();
        nonFixedPitchAlgorithm.maxRuntimeParam.setValue(timeLimit);
        ppIrregular.setParameter(nonFixedPitchAlgorithm.maxRuntimeParam, timeLimit);
        if (placementNodes.size() > 100) {
            Cell newCell;
            System.out.println("Large placement task: breaking it into smaller tasks...");
            Library lib = decomposeAlgorithm.doBottomUp(placementNodes, allNetworks, exportsToPlace);
            System.out.println("Placement decomposed into new library: " + lib.getName());
            System.out.println();
            HashMap<Cell, Cell> placedCells = new HashMap<Cell, Cell>();
            ArrayList regularCells = new ArrayList();
            ArrayList irregularCells = new ArrayList();
            Cell allClusters = null;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getName().equals("ALLCLUSTERS")) {
                    allClusters = cell;
                    continue;
                }
                Boolean bl = this.getColumnPlacement(cell);
                if (bl == null) {
                    irregularCells.add(cell);
                    continue;
                }
                regularCells.add(cell);
            }
            Placement.PlacementPreferences ppRowCol = new Placement.PlacementPreferences(false);
            ppRowCol.placementAlgorithm = ((PlacementFrame)fixedPitchAlgorithm).getAlgorithmName();
            for (Cell cell : regularCells) {
                newCell = Placement.placeCellNoJob(cell, this.ep, fixedPitchAlgorithm, ppRowCol, true, job);
                if (newCell == null) continue;
                placedCells.put(cell, newCell);
            }
            for (Cell cell : irregularCells) {
                newCell = Placement.placeCellNoJob(cell, this.ep, nonFixedPitchAlgorithm, ppIrregular, true, job);
                if (newCell == null) continue;
                placedCells.put(cell, newCell);
            }
            if (allClusters != null) {
                Iterator<NodeInst> it2 = allClusters.getNodes();
                while (it2.hasNext()) {
                    Cell np;
                    Cell newCell2;
                    NodeInst nodeInst = it2.next();
                    if (!nodeInst.isCellInstance() || (newCell2 = (Cell)placedCells.get(np = (Cell)nodeInst.getProto())) == null || nodeInst.replace(newCell2, this.ep, false, false, false) != null) continue;
                    System.out.println("ERROR: Could not replace node " + nodeInst.describe(false) + " in cell " + allClusters.describe(false) + " with cell " + newCell2.describe(false));
                }
                for (Cell cell : placedCells.keySet()) {
                    Iterator<CellUsage> it3 = cell.getUsagesOf();
                    if (it3.hasNext()) continue;
                    cell.kill();
                }
                this.setRedispCell(allClusters);
                Placement.PlacementPreferences ppToplevel = new Placement.PlacementPreferences(false);
                ppToplevel.placementAlgorithm = recomposeAlgorithm.getAlgorithmName();
                Cell cell = Placement.placeCellNoJob(allClusters, this.ep, recomposeAlgorithm, ppToplevel, false, job);
                if (cell != null) {
                    this.setRedispCell(cell);
                }
            }
            this.setFailure(true);
        } else {
            Boolean useColumns = RowCol.isColumnPlacement(placementNodes, null, null, true);
            if (useColumns == null) {
                System.out.println("General Placement algorithm chooses " + nonFixedPitchAlgorithm.getAlgorithmName() + " to place the cell");
                nonFixedPitchAlgorithm.runPlacement(placementNodes, allNetworks, exportsToPlace, cellName, job);
                return;
            }
            System.out.println("General Placement algorithm chooses " + ((PlacementFrame)fixedPitchAlgorithm).getAlgorithmName() + " to place the cell");
            ((PlacementFrame)fixedPitchAlgorithm).runPlacement(placementNodes, allNetworks, exportsToPlace, cellName, job);
        }
    }

    public Boolean getColumnPlacement(Cell cell) {
        Double commonWid = -1.0;
        Double commonHei = -1.0;
        boolean foundCells = false;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            foundCells = true;
            if (commonWid != null) {
                if (commonWid < 0.0) {
                    commonWid = ni.getXSize();
                }
                if (commonWid.doubleValue() != ni.getXSize()) {
                    commonWid = null;
                }
            }
            if (commonHei == null) continue;
            if (commonHei < 0.0) {
                commonHei = ni.getYSize();
            }
            if (commonHei.doubleValue() == ni.getYSize()) continue;
            commonHei = null;
        }
        if (!foundCells) {
            return null;
        }
        if (commonWid == null && commonHei == null) {
            return null;
        }
        Boolean useColumns = Boolean.FALSE;
        if (commonWid != null && commonHei == null) {
            useColumns = Boolean.TRUE;
        }
        return useColumns;
    }
}

